{
  Shows how to draw page image onto the specified Canvas.
}

unit MFPaintMetafile;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Spin, ExtCtrls, SclRView;

type
  TFPaintMetafile = class(TForm)
    srve: TSRichViewEdit;
    Button1: TButton;
    PaintBox1: TPaintBox;
    Label1: TLabel;
    OpenDialog1: TOpenDialog;
    PageNo: TSpinEdit;
    PageNoVisible: TCheckBox;
    ClipMargins: TCheckBox;
    Button2: TButton;
    procedure PaintBox1Paint(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FPaintMetafile: TFPaintMetafile;

implementation

{$R *.DFM}

procedure TFPaintMetafile.PaintBox1Paint(Sender: TObject);
var
     Metafile : TMetafile;
begin
  Metafile := TMetafile.Create;
  Metafile.Width := PaintBox1.ClientWidth;
  Metafile.Height := PaintBox1.ClientHeight;
  srve.DrawMetafile(PageNo.Value, Metafile, PageNoVisible.Checked, ClipMargins.Checked, False);
  PaintBox1.Canvas.Draw(0, 0, Metafile);
  Metafile.Free;
end;

procedure TFPaintMetafile.Button1Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
    srve.LoadRVF(OpenDialog1.FileName);
  PaintBox1.Repaint;
end;

procedure TFPaintMetafile.Button2Click(Sender: TObject);
begin
  PaintBox1.Repaint;
end;

end.
